<?php

include "configuration_template.php";

$template_pagetitle = $template_name . "_privacypolicy_name";
$template_pageurl = $privacypolicy_page;
$template_pagetpl = $privacypolicy_tpl;





use WHMCS\Authentication\CurrentUser;
use WHMCS\ClientArea;
use WHMCS\Database\Capsule;

define('CLIENTAREA', true);

require __DIR__ . '/init.php';

$z0mlang = getz0mlang();

$ca = new ClientArea();

$ca->setPageTitle($whmcs->get_lang($template_pagetitle));

$ca->addToBreadCrumb('index.php', Lang::trans('globalsystemname'));
$ca->addToBreadCrumb($template_pageurl, $whmcs->get_lang($template_pagetitle));

$ca->initPage();

$currentUser = new CurrentUser();
$authUser = $currentUser->user();

// Check login status
if ($authUser) {

    $ca->assign('userFullname', $authUser->fullName);


    $selectedClient = $currentUser->client();
    if ($selectedClient) {

        $ca->assign(
            'clientInvoiceCount',
            $selectedClient->invoices()->count()
        );
    }

} else {

    $ca->assign('userFullname', 'Guest');

}

$ca->setTemplate($template_pagetpl);

$ca->output();